/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.BaseObjects;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.Search;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.StoredSearch;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWException;
import filenet.vw.idm.toolkit.IVWIDMContents;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMContents;
import filenet.vw.idm.trident.VWIDMTridentCustomObject;
import filenet.vw.idm.trident.VWIDMTridentDocument;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentLibrary;
import filenet.vw.idm.trident.VWIDMTridentStoredSearch;
import filenet.vw.idm.trident.VWTridentFactory;
import filenet.vw.idm.trident.VWTridentFactoryProperties;
import filenet.vw.ntutil.QTimer;
import java.util.Iterator;
import java.util.Vector;

public class VWIDMTridentFolder
extends VWIDMTridentItem
implements IVWIDMFolder {
    String m_pathName = null;
    Folder m_folder = null;
    private static final String m_className = "VWIDMTridentFolder";
    private int m_filterFolderMaxResult = -1;

    private String getPathName() throws VWException {
        if (this.m_pathName == null) {
            this.m_pathName = (String)this.getProp("PathName");
        }
        return this.m_pathName;
    }

    protected Folder getCEFolder() {
        return this.m_folder;
    }

    protected VWIDMTridentFolder(Folder folder, VWIDMTridentLibrary lib) {
        this.m_wcmObject = folder;
        this.m_folder = folder;
        this.m_lib = lib;
        this.m_id = this.m_wcmObject.getId();
        this.m_labelPropName = this.m_lib.getFolderNameProperty();
    }

    protected VWIDMTridentFolder(Folder folder, VWIDMTridentLibrary lib, WcmDlgItem dlgItem) {
        this.m_wcmObject = folder;
        this.m_folder = folder;
        this.m_lib = lib;
        this.m_dlgItem = dlgItem;
        this.m_id = this.m_wcmObject.getId();
        this.m_labelPropName = this.m_lib.getFolderNameProperty();
    }

    public String getLibraryId() {
        return this.m_lib.getId();
    }

    public String getLibraryLabel() {
        return this.m_lib.getLabel();
    }

    public String getCanonicalName() {
        return Integer.toString(2) + ":" + this.m_lib.toString() + ":" + this.m_id;
    }

    public IVWIDMItem[] list(boolean dirOnly) throws VWException {
        if (!dirOnly) {
            return this.list();
        }
        this.clearContents();
        this.m_dirty = false;
        this.initContents(new int[]{2}, null);
        return this.m_contents;
    }

    public Object getProp(String propName) throws VWException {
        String m_method = "getProp:" + propName;
        if (this.m_folder == null) {
            throw new VWException("idm.trident.IDMTridentFolder.getProp1", "No object is available.");
        }
        try {
            Property prop;
            Object retVal = null;
            Properties props = this.m_folder.getProperties(new String[]{propName});
            if (props != null && (prop = (Property)props.get(0)) != null) {
                retVal = VWIDMTridentFolder.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentFolder.getProp2", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    public void save() throws VWException {
        if (this.m_folder == null) {
            throw new VWException("idm.trident.IDMTridentFolder.save", "No object is available.");
        }
        String m_method = "save:" + this.getId();
        Properties propsToSave = this.getSaveProperties();
        if (propsToSave != null) {
            try {
                this.m_folder.setProperties(propsToSave);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
            }
        }
    }

    public int getType() {
        return 2;
    }

    public IVWIDMLibrary getLibrary() throws VWException {
        return this.m_lib;
    }

    public IVWIDMContents listContents(String docClass, int initBufferSize, String[] propertyNames) throws VWException {
        return this.listContents(new String[]{docClass}, initBufferSize, propertyNames);
    }

    public IVWIDMContents listContents(String[] docClasses, int initBufferSize, String[] propertyNames) throws VWException {
        return this.listContents(docClasses, initBufferSize, propertyNames, null);
    }

    private int getFilterFolderMaxResult() {
        try {
            if (this.m_filterFolderMaxResult == -1) {
                this.m_filterFolderMaxResult = (Integer)VWIDMBaseFactory.instance().getProperties().getProperty("filterFolderMaxResults");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_filterFolderMaxResult;
    }

    public IVWIDMContents listContentsAx(String[] docClasses, int initBufferSize, String[] propertyNames, String filterString) throws VWException {
        String m_method = "listContents";
        int maxRecords = Math.max(this.getFilterFolderMaxResult(), initBufferSize);
        int nDocClasses = docClasses == null ? 0 : docClasses.length;
        boolean overflowAlert = false;
        for (int j = 0; j < nDocClasses; ++j) {
            docClasses[j] = VWTridentFactory.MapDocClassName(docClasses[j]);
        }
        VWIDMTridentItem[] saveContents = this.m_contents;
        VWIDMContents res = null;
        QTimer timer = new QTimer();
        StringBuffer buf = new StringBuffer();
        buf.append("<request><objectstores mergeoption='union'><objectstore id='").append(this.m_lib.getName()).append("'/></objectstores><querystatement>SELECT d.Id");
        int nProps = propertyNames == null ? 0 : propertyNames.length;
        for (int i = 0; i < nProps; ++i) {
            buf.append(", d.").append(propertyNames[i]);
        }
        buf.append(" From Document d where d.This INFOLDER '");
        buf.append(this.getPathName());
        buf.append("'");
        if (filterString != null) {
            buf.append(" AND ");
            buf.append(filterString);
        }
        buf.append(" AND IsClass(d, ");
        String preTemplate = buf.toString();
        String postTemplate = ") </querystatement><options maxrecords='" + Integer.toString(maxRecords) + "' cursorlocation='client'  objectasid='false'/></request>";
        Session mySession = ((VWTridentFactoryProperties)VWIDMBaseFactory.instance().getProperties()).getSession();
        Vector<VWIDMTridentDocument> contents = new Vector<VWIDMTridentDocument>();
        for (int dc = 0; dc < nDocClasses; ++dc) {
            StringBuffer buf2 = new StringBuffer(preTemplate);
            buf2.append(docClasses[dc]).append(postTemplate);
            String statement1 = buf2.toString();
            if (logger.isFinest()) {
                logger.finest(m_className, "listContents", statement1);
            }
            try {
                int sz;
                Search mySearch = ObjectFactory.getSearch((Session)mySession);
                BaseObjects bos = mySearch.singleObjectTypeExecute(statement1, 1);
                int n = sz = bos == null ? 0 : bos.size();
                if (sz <= 0) continue;
                Iterator it = bos.iterator();
                boolean i = false;
                while (it.hasNext()) {
                    Object ro = it.next();
                    if (!(ro instanceof Document)) continue;
                    contents.add(new VWIDMTridentDocument((Document)ro, this.m_lib));
                }
                if (sz < maxRecords) continue;
                overflowAlert = true;
                continue;
            }
            catch (Exception e) {
                logger.throwing(m_className, "listContents", e);
                throw new VWException(e);
            }
        }
        if (contents.size() > 0) {
            res = new VWIDMContents(contents.toArray(new IVWIDMItem[0]), maxRecords, overflowAlert);
        }
        contents.clear();
        timer.stop();
        if (logger.isFinest()) {
            logger.finest(m_className, "listContents", "TIMER:filtering for doc classes took " + timer.elapsed());
        }
        return res;
    }

    public IVWIDMContents listContents(String[] docClasses, int initBufferSize, String[] propertyNames, String filterString) throws VWException {
        String m_method = "listContentsEx";
        int maxRecords = initBufferSize;
        int nDocClasses = docClasses == null ? 0 : docClasses.length;
        boolean overflowAlert = false;
        for (int j = 0; j < nDocClasses; ++j) {
            docClasses[j] = VWTridentFactory.MapDocClassName(docClasses[j]);
        }
        VWIDMTridentItem[] saveContents = this.m_contents;
        VWIDMContents res = null;
        QTimer timer = new QTimer();
        StringBuffer buf = new StringBuffer();
        buf.append("<request><objectstores mergeoption='union'><objectstore id='").append(this.m_lib.getName()).append("'/></objectstores><querystatement>SELECT d.Id");
        int nProps = propertyNames == null ? 0 : propertyNames.length;
        for (int i = 0; i < nProps; ++i) {
            buf.append(", d.").append(propertyNames[i]);
        }
        buf.append(" From Document d where d.This INFOLDER '");
        buf.append(this.getPathName());
        buf.append("'");
        if (filterString != null) {
            buf.append(" AND ");
            buf.append(filterString);
        }
        buf.append(" AND (");
        for (int dc = 0; dc < nDocClasses; ++dc) {
            buf.append(" IsClass(d, ").append(docClasses[dc]);
            if (dc < nDocClasses - 1) {
                buf.append(") OR");
                continue;
            }
            buf.append(")");
        }
        buf.append(") </querystatement><options maxrecords='").append(maxRecords).append("' cursorlocation='client'  objectasid='false'/></request>");
        Session mySession = ((VWTridentFactoryProperties)VWIDMBaseFactory.instance().getProperties()).getSession();
        Vector<VWIDMTridentDocument> contents = new Vector<VWIDMTridentDocument>();
        String statement1 = buf.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "listContentsEx", statement1);
        }
        try {
            int sz;
            Search mySearch = ObjectFactory.getSearch((Session)mySession);
            BaseObjects bos = mySearch.singleObjectTypeExecute(statement1, 1);
            int n = sz = bos == null ? 0 : bos.size();
            if (sz > 0) {
                Iterator it = bos.iterator();
                boolean i = false;
                while (it.hasNext()) {
                    Object ro = it.next();
                    if (!(ro instanceof Document)) continue;
                    contents.add(new VWIDMTridentDocument((Document)ro, this.m_lib));
                }
                if (sz >= maxRecords) {
                    overflowAlert = true;
                }
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "listContentsEx", e);
            throw new VWException(e);
        }
        if (contents.size() > 0) {
            res = new VWIDMContents(contents.toArray(new IVWIDMItem[0]), maxRecords, overflowAlert);
        }
        contents.clear();
        timer.stop();
        if (logger.isFinest()) {
            logger.finest(m_className, "listContentsEx", "TIMER:filtering for doc classes took " + timer.elapsed());
        }
        return res;
    }

    public static Object getProp(Folder folder, String propName) throws VWException {
        if (folder == null) {
            throw new VWException("idm.trident.IDMTridentFolder.getProp1", "No object is available.");
        }
        String m_method = "getProp:" + propName + ":" + folder.getId();
        try {
            Object retVal = null;
            Properties props = folder.getProperties(new String[]{propName});
            if (props != null) {
                Property prop = (Property)props.get(0);
                retVal = VWIDMTridentItem.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentFolder.getProp2", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    protected void initContents() throws VWException {
        this.initContents(new int[]{15, 1, 2, -100}, null);
    }

    private void initContents(int[] types, String[] propNames) throws VWException {
        if (this.m_folder == null) {
            throw new VWException("idm.trident.Folder.initContents", "No object is available.");
        }
        String m_method = "initContents";
        try {
            BaseObjects objs = null;
            QTimer timer = new QTimer();
            objs = propNames != null ? this.m_folder.getContainees(types, propNames) : this.m_folder.getContainees(types);
            logger.info(m_className, m_method, "TIMER: Folder.getContainees took " + timer.elapsed());
            if (objs != null && objs.size() > 0) {
                int size = objs.size();
                this.m_contents = new VWIDMTridentItem[size];
                for (int i = 0; i < size; ++i) {
                    BaseObject obj = (BaseObject)objs.get(i);
                    if (obj == null) continue;
                    if (obj instanceof Document) {
                        this.m_contents[i] = new VWIDMTridentDocument((Document)obj, this.m_lib);
                    }
                    if (obj instanceof CustomObject) {
                        this.m_contents[i] = new VWIDMTridentCustomObject((CustomObject)obj, this.m_lib);
                    }
                    if (obj instanceof Folder) {
                        this.m_contents[i] = new VWIDMTridentFolder((Folder)obj, this.m_lib);
                    }
                    if (!(obj instanceof StoredSearch)) continue;
                    this.m_contents[i] = new VWIDMTridentStoredSearch((StoredSearch)obj, this.m_lib);
                }
                objs.clear();
            }
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.initContents", "Exception: {0}", e.getMessage());
        }
    }
}

